<?php
function testimonial() {
    ob_start(); ?>
<!-- Slick Slider CSS -->

    <style>
        /* Slider Container */
        .testimonial-slider {
            max-width: 100%;
            margin: auto;
            overflow: hidden;
			margin-bottom:0px!important;
        }

        /* Individual Testimonial Item */
        .testimonial-item {
            background: #FDFBF8;
            padding: 20px 40px;
            text-align: center;
            border-radius: 10px;
            transition: all 0.5s ease;
            opacity:1;
            transform: scale(0.7);
        }
		.testimonial-item img{
			margin-bottom:10px;
		}
		.testimonial-details{
			display: grid!important;
			grid-template-columns:60% 40%;
			align-items: flex-end;
			gap: 0px;
			flex-direction:row;
			justify-content:space-between;
			justify-items: end;
		}
		.md-modal .testimonial-details{
			display: flex!important;
			align-items: flex-start;
			flex-direction:column;
		}
		.md-modal .testimonial-details .personel-details{
			margin-bottom:10px;
		}
		.testimonial-item p{
			font-weight: 400;
			font-size: 16px;
			line-height: 24px;
			letter-spacing: 0;
			text-align:left;
			margin-bottom:0px;
		}
		.testimonial-item h4{
			font-weight: 500;
			font-size: 20px;
			line-height: 27px;
			letter-spacing: 0;
			margin:0px;
			text-align:left;
		}
		.testimonial-details h5{
			font-weight: 400;
			font-size: 16px;
			line-height: 20px;
			letter-spacing: 0%;
			margin:0px;
			text-align:left;
		}
        /* Center (Active) Slide Styling */
        .testimonial-holder .slick-center{
            transform: scale(1);
            opacity: 1;
            filter: blur(0);
			background:#fff;
        }

        /* Slick Dots Customization */
        .testimonial-holder .slick-dots {
            bottom: -20px;
        }

        .testimonial-holder .slick-dots li button:before {
            font-size: 12px;
            color: #333;
        }

        .testimonial-holder .slick-dots li.slick-active button:before {
            color: #007bff;
        }
		.testimonial-holder .slick-dots li button:focus, .testimonial-holder [type=button]:hover, .testimonial-holder .slick-dots li button:focus, .testimonial-holder .slick-dots li button:hover, .testimonial-holder .slick-dots li button:focus, .testimonial-holder .slick-dots li button:hover {
		color: #fff;
		background-color: unset;
		text-decoration: none;
	}
		.extra-designation{
			display:none;
		}
		.read-more-testi{
			    display: inline-block;
				font-size: 12px;
				color: #000;
				text-decoration: underline;
		}
		
		.md-modal {
    margin: auto;
    position: fixed;
    top: 175px;
    left: 0;
    right: 0;
    width: 60%;
    max-width: 60%;
    min-width: 320px;
    height: auto;
    z-index: 2000;
    visibility: hidden;
    -webkit-backface-visibility: hidden;
    -moz-backface-visibility: hidden;
    backface-visibility: hidden;
    background: #fff;
    padding: 40px;
}

.md-show {
  visibility: visible;
}

.md-overlay {
  position: fixed;
  width: 100%;
  height: 100%;
  visibility: hidden;
  top: 0;
  left: 0;
  z-index: 1000;
  opacity: 0;
  background: rgba(228, 240, 227, 0.8);
  -webkit-transition: all 0.3s;
  -moz-transition: all 0.3s;
  transition: all 0.3s;
}

.md-show ~ .md-overlay {
  opacity: 1;
  visibility: visible;
  display:block!important;
}

.md-effect-12 .md-content {
  -webkit-transform: scale(0.8);
  -moz-transform: scale(0.8);
  -ms-transform: scale(0.8);
  transform: scale(0.8);
  opacity: 0;
  -webkit-transition: all 0.3s;
  -moz-transition: all 0.3s;
  transition: all 0.3s;
}

.md-show.md-effect-12 ~ .md-overlay {
  background-color: #171717e3;
}

.md-effect-12 .md-content h3,
.md-effect-12 .md-content {
  background: transparent;
}

.md-show.md-effect-12 .md-content {
  -webkit-transform: scale(1);
  -moz-transform: scale(1);
  -ms-transform: scale(1);
  transform: scale(1);
  opacity: 1;
}
.md-close{
    position: absolute;
    top: -65px;
    right: -65px;
    width: 43px;
    height: 43px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    background: none;
    border: none;
    padding: 0;
    cursor: pointer;
    transition: .5s ease all;
}
.md-close:hover{
  background:#009593;
  border-color:#009593;
}
.md-close:hover svg g{
  fill:#000;
}
		.logo-absolute{
			position:absolute;
			top:20px;
			right:40px;
			width: 100px;
		}
		.testimonial-slider .slick-next:before, .testimonial-slider .slick-prev:before{
			display:none;
		}
		.testimonial-slider .slick-next{
			top: 100px;
    		right: 17px;
    		transform: rotate(90deg);
		}
		.testimonial-slider .slick-prev{
			top: 25px;
			right: 17px;
			left: auto;
			transform: rotate(90deg);
		}
@media screen and (min-width: 1024px) {
		.custom-dots{
			position: absolute;
    		right: -25px;
			bottom:40px;
		}
		/* Custom Dots as Scrollbar */
        .custom-dots {
            display: flex;
            flex-direction: column;
            gap: 5px;
            height: auto; /* Adjust to match slider height */
        }
		.custom-dots ul{
			display:flex;
			flex-direction:column;
			align-items:center;
		}
        .custom-dots li {
            list-style: none;
            width: 1px;
            height: 80px;
            background: #ddd;
            border-radius: 5px;
            transition: background 0.3s, height 0.3s;
        }

        .custom-dots li.slick-active {
            background: #000;
			height: 40px;
			width: 4px;
        }
		.custom-dots li button{
			    width: 0px;
				height: 0px;
				background: transparent;
				opacity:0;
		}
		.custom-dots li button:before{
			display:none;
		}
		}
		@media screen and (max-width: 990px) {
			.testimonial-item {
				transform: scale(1);
            	opacity: 1;
            	filter: blur(0);
			}
			.testimonial-details{
				flex-direction:column;
				align-items: flex-start;
			}
			.testimonial-slider{
				margin-bottom :20px!important;
			}
			.testimonial-item {
    			padding: 20px 20px;
			}
			.testimonial-details{
				grid-template-columns:100%;
				justify-items: start;
			}
		}
    </style>

    <!-- Testimonial Slider -->
<div class="testimonial-holder">
	<div class="testimonial-slider">
		<?php
$args = array(
    'post_type'      => 'testimonial',
    'posts_per_page' => -1,
    'post_status'    => 'publish' // only get published posts
);

$testimonials = new WP_Query($args);

if ($testimonials->have_posts()) :
    while ($testimonials->have_posts()) : $testimonials->the_post();
        $company = get_field('company'); // ACF field
        ?>
		<div class="testimonial-item">
			<div class="testimonial-details">
				<div class="content">
					<img src="<?php echo site_url(); ?>/wp-content/uploads/2025/04/Quote.png"/>
					<!--<img class="logo-absolute" src="https://web.pinklemonadedigital.com/indyafoods/wp-content/uploads/2025/04/Group-6534-1.png"/>-->
				<?php $text = get_the_content();

				 $name=get_the_title();

				echo '<p>' . trim_characters_with_read_more($text,$name,$company, 150) . '</p>'; ?>
				</div>
				<div class="personel-details">
				<h4><?php echo get_the_title(); ?></h4>
				<!--<h6 class="extra-designation">Designation</h6>-->
				<h5><?php echo $company; ?></h5>
				</div>
			</div>
		</div>
		<?php
    endwhile;
    wp_reset_postdata();
else :
    echo '<p>No testimonials found.</p>';
endif;
?>
		
	</div>
	<!-- Custom Dots Container (Outside Slider) -->
    <div class="custom-dots"></div>
</div>
    <!-- Slick Slider JS -->
<div class="md-modal md-effect-12">
    <div class="md-content">
       <div class="testimonial-details">
				<div class="content">
					<img src="<?php echo site_url(); ?>/wp-content/uploads/2025/04/Quote.png"/>
					<div class="testi-cont">
						
					</div>
				</div>
				<div class="personel-details">
				<h4></h4>
				<h5 class="place"></h5>
				</div>
			</div>
		<button class="md-close"><svg width="43" height="43" viewBox="0 0 43 43" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21.5 2.6875C11.0188 2.6875 2.6875 11.0188 2.6875 21.5C2.6875 31.9813 11.0188 40.3125 21.5 40.3125C31.9813 40.3125 40.3125 31.9813 40.3125 21.5C40.3125 11.0188 31.9813 2.6875 21.5 2.6875ZM28.7563 30.9062L21.5 23.65L14.2438 30.9062L12.0938 28.7563L19.35 21.5L12.0938 14.2438L14.2438 12.0938L21.5 19.35L28.7563 12.0938L30.9062 14.2438L23.65 21.5L30.9062 28.7563L28.7563 30.9062Z" fill="#A100FF"/>
</svg></button>
    </div>
</div>

<div class="md-overlay"></div>
<script>
  jQuery(function () {
  
  jQuery('.md-trigger').on('click', function(e) {
    e.preventDefault();
	 var text = jQuery(this).attr('text');
    var name = jQuery(this).attr('name');
    var designation = jQuery(this).attr('designation');
    var company = jQuery(this).attr('company');
	jQuery('.md-modal').find('.testi-cont').html(text);
	 jQuery('.md-modal').find('.personel-details h4').html(name);
	  jQuery('.md-modal').find('.place').html(company);
    jQuery('.md-modal').addClass('md-show');
  });
  
  jQuery('.md-close').on('click', function() {
    jQuery('.md-modal').removeClass('md-show');
  });
  
});
</script>
    <script>
        jQuery(document).ready(function(){
            var slider = jQuery(".testimonial-slider");

            slider.slick({
                slidesToShow: 3,  // Show 3 items at a time
                slidesToScroll: 1,
                autoplay: true,
                autoplaySpeed: 3000,
                speed: 600,
                vertical: true,  // Enable vertical mode
                centerMode: true,  // Center the active slide
                centerPadding: "0px",
                infinite: true,
                arrows: true, // Hide prev/next buttons
                dots: false, // Show navigation dots
				prevArrow: '<button class="slick-prev"><svg width="35" height="34" viewBox="0 0 35 34" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M32.0722 23.898C32.259 23.4942 32.0818 23.0148 31.6793 22.8293C31.2754 22.6425 30.796 22.8197 30.6105 23.2235C29.381 25.8638 27.4194 28.0921 24.9838 29.6458C22.6278 31.1486 19.8268 32.0196 16.8169 32.0196C12.6176 32.0196 8.81773 30.3175 6.06625 27.5674C3.31606 24.8172 1.61407 21.0161 1.61407 16.8168C1.61407 12.6174 3.3161 8.81763 6.06625 6.06614C8.8178 3.31596 12.6176 1.61397 16.8169 1.61397C19.8267 1.61397 22.6276 2.48492 24.9838 3.98776C27.4194 5.54144 29.3825 7.76964 30.6105 10.41C30.796 10.8139 31.2754 10.9897 31.6793 10.8043C32.0832 10.6188 32.259 10.1394 32.0722 9.73549C30.7149 6.81633 28.5417 4.35174 25.8479 2.63206C23.2351 0.965728 20.1375 0 16.817 0C12.1724 0 7.9689 1.88201 4.92623 4.92623C1.88208 7.97038 0 12.1738 0 16.8184C0 21.4629 1.88201 25.6665 4.92623 28.7105C7.97045 31.7546 12.1739 33.6368 16.817 33.6368C20.1359 33.6368 23.2364 32.671 25.8479 31.0047C28.5432 29.2848 30.7151 26.8205 32.0722 23.9013V23.898ZM13.884 17.6228H33.6297C34.0748 17.6228 34.4375 17.2615 34.4375 16.815C34.4375 16.37 34.0762 16.0073 33.6297 16.0073H13.884L19.9173 10.6717C20.2498 10.3777 20.28 9.86948 19.9874 9.53701C19.6934 9.20457 19.1852 9.17296 18.8527 9.46695L11.2256 16.212C10.8932 16.506 10.863 17.0143 11.1555 17.3467C11.1803 17.3742 11.205 17.3989 11.2311 17.4223L18.8511 24.1603C19.1836 24.4543 19.6918 24.4241 19.9858 24.0903C20.2798 23.7578 20.2496 23.2496 19.9158 22.9556L13.8825 17.62L13.884 17.6228Z" fill="#1A2148"/></svg></button>',
                nextArrow: '<button class="slick-next"><svg width="35" height="34" viewBox="0 0 35 34" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M2.92781 23.898C2.74099 23.4942 2.9182 23.0148 3.3207 22.8293C3.72456 22.6425 4.204 22.8197 4.38947 23.2235C5.61895 25.8638 7.58062 28.0921 10.0162 29.6458C12.3722 31.1486 15.1732 32.0196 18.1831 32.0196C22.3824 32.0196 26.1823 30.3175 28.9338 27.5674C31.6839 24.8172 33.3859 21.0161 33.3859 16.8168C33.3859 12.6174 31.6839 8.81763 28.9338 6.06614C26.1822 3.31596 22.3824 1.61397 18.1831 1.61397C15.1733 1.61397 12.3724 2.48492 10.0162 3.98776C7.58062 5.54144 5.61751 7.76964 4.38947 10.41C4.20402 10.8139 3.7246 10.9897 3.3207 10.8043C2.91684 10.6188 2.74101 10.1394 2.92781 9.73549C4.28506 6.81633 6.45825 4.35174 9.15207 2.63206C11.7649 0.965728 14.8625 0 18.183 0C22.8276 0 27.0311 1.88201 30.0738 4.92623C33.1179 7.97038 35 12.1738 35 16.8184C35 21.4629 33.118 25.6665 30.0738 28.7105C27.0296 31.7546 22.8261 33.6368 18.183 33.6368C14.8641 33.6368 11.7636 32.671 9.15207 31.0047C6.45681 29.2848 4.28492 26.8205 2.92781 23.9013V23.898ZM21.116 17.6228H1.37026C0.92518 17.6228 0.5625 17.2615 0.5625 16.815C0.5625 16.37 0.923773 16.0073 1.37026 16.0073H21.116L15.0827 10.6717C14.7502 10.3777 14.72 9.86948 15.0126 9.53701C15.3066 9.20457 15.8148 9.17296 16.1473 9.46695L23.7744 16.212C24.1068 16.506 24.137 17.0143 23.8445 17.3467C23.8197 17.3742 23.795 17.3989 23.7689 17.4223L16.1489 24.1603C15.8164 24.4543 15.3082 24.4241 15.0142 24.0903C14.7202 23.7578 14.7504 23.2496 15.0842 22.9556L21.1175 17.62L21.116 17.6228Z" fill="#1A2148"/></svg></button>',
				appendDots: jQuery(".custom-dots"),
				responsive: [
				{
				  breakpoint: 1280,
				  settings: {
					centerPadding: '0px',
				  },
				  breakpoint: 990,
				  settings: {
					slidesToShow: 2,
					centerMode: false,
					dots: true,
					  vertical: false,
					  arrows: false,
				  },
				  breakpoint: 478,
				  settings: {
					slidesToShow: 1,
					centerMode: false,
					dots: true,
					 vertical: false,
					  arrows: false,
				  }
				}
			  ]
            });

            // Apply active class on init
            jQuery(".slick-center .testimonial-item").addClass("active");

            // Detect when slides change and update active slide
            slider.on("afterChange", function(){
                jQuery(".testimonial-item").removeClass("active");
                jQuery(".slick-center .testimonial-item").addClass("active");
				//jQuery(".slick-center").find('img').attr('src','https://web.pinklemonadedigital.com/onlineinstrument/wp-content/uploads/2025/03/Vector-3-1.png');
            });
        });
    </script>
    <?php
return ob_get_clean();
}
add_shortcode('show_testimonial', 'testimonial');
?>