<?php
/**
 * The template for displaying singular post-types: posts, pages and user-defined custom post types.
 *
 * @package HelloElementor
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

while ( have_posts() ) :
	the_post();
$post_type = get_post_type();
$item_category='';
$category = wp_get_post_terms(get_the_ID(), 'blog_category', array('fields' => 'slugs'));
				if (!empty($category)) : $i=1; 
                    foreach ($category as $cat) : 
                        $item_category=$cat;
						if($i==1){
							break;
						}
                    endforeach;
                endif;
	?>
<main id="content" <?php post_class( 'site-main' ); ?>>

	<?php if ( is_single() ) { ?>

	<div class="current-blog-content">
		<!-- Display Featured Image -->
		<?php if ( apply_filters( 'hello_elementor_page_title', true ) ) : ?>
			<div class="single-container insights-main-heading">
						<div class="page-header">
				<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
						</div>
			</div>
		<?php endif; ?>

		<div class="page-content">
			<?php the_content(); ?>

			<?php wp_link_pages(); $tags = get_the_terms(get_the_ID(), 'post_tag');?>
		</div>

		<?php //comments_template(); ?>
	</div>
	<div class="insights-next-prev-arrows">
		<div class="insights-navigation">
			<div class="nav-previous">
				<?php
				// Display previous post link with an arrow icon
				$prev_post = get_previous_post();
				if (!empty($prev_post)) {
					$prev_link=get_permalink($prev_post->ID);
					$disabled='';
				}
				else{
					$prev_link="";
					$disabled='disabled';
				}
					echo '<a href="' . $prev_link . '" class="prev-arrow '.$disabled.'">';
					echo '<span class="arrow"><span class="nav-text">Previous</span> <svg width="35" height="34" viewBox="0 0 35 34" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M32.0722 23.898C32.259 23.4942 32.0818 23.0148 31.6793 22.8293C31.2754 22.6425 30.796 22.8197 30.6105 23.2235C29.381 25.8638 27.4194 28.0921 24.9838 29.6458C22.6278 31.1486 19.8268 32.0196 16.8169 32.0196C12.6176 32.0196 8.81773 30.3175 6.06625 27.5674C3.31606 24.8172 1.61407 21.0161 1.61407 16.8168C1.61407 12.6174 3.3161 8.81763 6.06625 6.06614C8.8178 3.31596 12.6176 1.61397 16.8169 1.61397C19.8267 1.61397 22.6276 2.48492 24.9838 3.98776C27.4194 5.54144 29.3825 7.76964 30.6105 10.41C30.796 10.8139 31.2754 10.9897 31.6793 10.8043C32.0832 10.6188 32.259 10.1394 32.0722 9.73549C30.7149 6.81633 28.5417 4.35174 25.8479 2.63206C23.2351 0.965728 20.1375 0 16.817 0C12.1724 0 7.9689 1.88201 4.92623 4.92623C1.88208 7.97038 0 12.1738 0 16.8184C0 21.4629 1.88201 25.6665 4.92623 28.7105C7.97045 31.7546 12.1739 33.6368 16.817 33.6368C20.1359 33.6368 23.2364 32.671 25.8479 31.0047C28.5432 29.2848 30.7151 26.8205 32.0722 23.9013V23.898ZM13.884 17.6228H33.6297C34.0748 17.6228 34.4375 17.2615 34.4375 16.815C34.4375 16.37 34.0762 16.0073 33.6297 16.0073H13.884L19.9173 10.6717C20.2498 10.3777 20.28 9.86948 19.9874 9.53701C19.6934 9.20457 19.1852 9.17296 18.8527 9.46695L11.2256 16.212C10.8932 16.506 10.863 17.0143 11.1555 17.3467C11.1803 17.3742 11.205 17.3989 11.2311 17.4223L18.8511 24.1603C19.1836 24.4543 19.6918 24.4241 19.9858 24.0903C20.2798 23.7578 20.2496 23.2496 19.9158 22.9556L13.8825 17.62L13.884 17.6228Z" fill="#1A2148"/></svg></span>';
					echo '</a>';
				?>
			</div>
		<div class="nav-line"></div>
			<div class="nav-next">
				<?php
				// Display next post link with an arrow icon
				$next_post = get_next_post();
				if (!empty($next_post)) {
					$next_link=get_permalink($next_post->ID);
					$disabled='';
				}
				else{
					$next_link="";
					$disabled='disabled';
				}
					echo '<a href="' . $next_link . '" class="next-arrow '.$disabled.'">';
					echo '<span class="arrow"><svg width="35" height="34" viewBox="0 0 35 34" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M2.92781 23.898C2.74099 23.4942 2.9182 23.0148 3.3207 22.8293C3.72456 22.6425 4.204 22.8197 4.38947 23.2235C5.61895 25.8638 7.58062 28.0921 10.0162 29.6458C12.3722 31.1486 15.1732 32.0196 18.1831 32.0196C22.3824 32.0196 26.1823 30.3175 28.9338 27.5674C31.6839 24.8172 33.3859 21.0161 33.3859 16.8168C33.3859 12.6174 31.6839 8.81763 28.9338 6.06614C26.1822 3.31596 22.3824 1.61397 18.1831 1.61397C15.1733 1.61397 12.3724 2.48492 10.0162 3.98776C7.58062 5.54144 5.61751 7.76964 4.38947 10.41C4.20402 10.8139 3.7246 10.9897 3.3207 10.8043C2.91684 10.6188 2.74101 10.1394 2.92781 9.73549C4.28506 6.81633 6.45825 4.35174 9.15207 2.63206C11.7649 0.965728 14.8625 0 18.183 0C22.8276 0 27.0311 1.88201 30.0738 4.92623C33.1179 7.97038 35 12.1738 35 16.8184C35 21.4629 33.118 25.6665 30.0738 28.7105C27.0296 31.7546 22.8261 33.6368 18.183 33.6368C14.8641 33.6368 11.7636 32.671 9.15207 31.0047C6.45681 29.2848 4.28492 26.8205 2.92781 23.9013V23.898ZM21.116 17.6228H1.37026C0.92518 17.6228 0.5625 17.2615 0.5625 16.815C0.5625 16.37 0.923773 16.0073 1.37026 16.0073H21.116L15.0827 10.6717C14.7502 10.3777 14.72 9.86948 15.0126 9.53701C15.3066 9.20457 15.8148 9.17296 16.1473 9.46695L23.7744 16.212C24.1068 16.506 24.137 17.0143 23.8445 17.3467C23.8197 17.3742 23.795 17.3989 23.7689 17.4223L16.1489 24.1603C15.8164 24.4543 15.3082 24.4241 15.0142 24.0903C14.7202 23.7578 14.7504 23.2496 15.0842 22.9556L21.1175 17.62L21.116 17.6228Z" fill="#1A2148"/></svg><span class="nav-text">Next</span></span>';
					echo '</a>';
				?>
			</div>
			</div>
		</div>
	<div class="single-container">
	<div class="related-insights">
		<h2>Related <span>Insights</span></h2>
		<div class="latest-content">
			<?php $args = array(
					'post_type'      => 'blog',
					'order'          => 'DESC',
					'posts_per_page' => 3,
					'post_status'    => 'publish',
					'post__not_in'   => array(get_the_ID()),
					'tax_query'      => array(
						array(
							'taxonomy' => 'blog_category', // Change this to your custom taxonomy
							'field'    => 'slug',
							'terms'    => $item_category,
						),
					),
				);
				$query = new WP_Query($args); 
				$postid =  $post->ID;
				$count = 0;
			?>

			<?php if ( $query->have_posts() ) { while ($query->have_posts()) { $query->the_post(); 
			$featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'full'); 
				$thumbnail_id  = get_post_thumbnail_id(get_the_ID());
  				$thumbnail_alt = get_post_meta( $thumbnail_id, '_wp_attachment_image_alt', true );		
				$date = get_the_date();
				$post_date=date('F j, Y', strtotime($date));
				$tags = get_the_terms(get_the_ID(), 'post_tag'); 
				$custom_author_name = get_post_meta(get_the_ID(), '_blog_author', true);
				$category = wp_get_post_terms(get_the_ID(), 'blog_category', array('fields' => 'names'));
				if (!empty($category)) : $i=1; 
                    foreach ($category as $cat) : 
                        $item_category_name=$cat;
						if($i==1){
							break;
						}
                    endforeach;
                endif;
			?>
			<div class="blog-each-holder case-study-each">
					<div class="blogs-info">
							<a href="<?php echo get_the_permalink(); ?>">
							<div class="img-txt1">
								<img decoding="async" src="<?php echo $featured_img_url; ?>" alt="<?php echo $thumbnail_alt; ?>" class="featured-blog-img">
							</div>
							<div class="blog-content">
								<div class="insight-cat">
									<p><?php echo $item_category_name; ?> | 5 min read</p>
								</div>
								<div class="img-txt2">
									<p><?php echo mb_strimwidth(get_the_title(), 0, 80, '...'); ?></p>
								</div>
								<div class="tag-holder">
								<?php if ($tags && !is_wp_error($tags)) : ?>
									<?php foreach ($tags as $tag) : ?>
										<span class="pills_button"><?php echo esc_html($tag->name); ?></span>
									<?php endforeach; ?>
							<?php endif; ?>
								</div>
								<div class="author-holder">
									<?php if (!empty($custom_author_name)) {
											echo '<p class="case-study-author">' . esc_html($custom_author_name) . '</p>';
										} else {
											echo '<p class="case-study-author">' . esc_html(get_the_author_meta('display_name')) . '</p>'; // Fallback to default author
										} ?>
								</div>
								<div class="blog-last">
									<p><svg width="18" height="11" viewBox="0 0 18 11" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.00893 2.95947C7.72404 2.95947 6.67871 4.00325 6.67871 5.28614C6.67871 6.56903 7.72404 7.61281 9.00893 7.61281C10.2938 7.61281 11.3392 6.56903 11.3392 5.28614C11.3392 4.00325 10.2938 2.95947 9.00893 2.95947ZM9.00893 7.16836C7.96916 7.16836 7.12316 6.32414 7.12316 5.28614C7.12316 4.24814 7.96916 3.40392 9.00893 3.40392C10.0487 3.40392 10.8945 4.24814 10.8945 5.28614C10.8945 6.32414 10.0487 7.16836 9.00893 7.16836Z" fill="black" stroke="black" stroke-width="0.727273"/>
<path d="M9 0.507324C5.436 0.507324 2.37111 2.46932 1 5.2851C2.37111 8.10088 5.436 10.0629 9 10.0629C12.5638 10.0629 15.6289 8.10088 17 5.2851C15.6289 2.46932 12.5638 0.507324 9 0.507324ZM9 9.61844C5.80022 9.61844 2.88111 7.92466 1.498 5.2851C2.88111 2.64555 5.80022 0.951769 9 0.951769C12.1996 0.951769 15.1189 2.64555 16.5022 5.2851C15.1189 7.92466 12.1996 9.61844 9 9.61844Z" fill="black" stroke="black" stroke-width="0.727273"/>
</svg> 3k Views</p>
								</div>
							</div>
							</a>
						</div>
					</div>
			<?php } // end while
				 } // end if

			?>
			<?php wp_reset_postdata(); 

			?>
		</div>
		<div class="view-more-cta-holder">
			<div class="elementor-button-wrapper">
				<a class="elementor-button elementor-button-link elementor-size-sm elementor-animation-push" href="<?php echo site_url(); ?>/insights?category=<?php echo $item_category; ?>">
					<span class="elementor-button-content-wrapper">
						<span class="elementor-button-text">VIEW  MORE</span>
					</span>
				</a>
			</div>
		</div>
	</div>
	</div>
<?php } else { ?>
	<?php if ( apply_filters( 'hello_elementor_page_title', true ) ) : ?>
		<div class="page-header">
			<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
		</div>
	<?php endif; ?>

	<div class="page-content">
		<?php the_content(); ?>

		<?php wp_link_pages(); ?>

		<?php if ( has_tag() ) : ?>
		<div class="post-tags">
			<?php the_tags( '<span class="tag-links">' . esc_html__( 'Tagged ', 'hello-elementor' ), ', ', '</span>' ); ?>
		</div>
		<?php endif; ?>
	</div>

	<?php comments_template(); } ?>
</main>

	<?php
endwhile;