<?php
include_once('templates/testimonial.php');
include_once('templates/testimonial_career.php');
include_once('templates/latest-insights.php');
include_once('templates/all-insights.php');
include_once('templates/job-openings.php');
include_once('templates/home-banner.php');
include_once('templates/industry-carousel.php');
include_once('templates/current-expansion.php');
include_once('meta-boxes/current_expansions.php');
include_once('meta-boxes/industry_carousel.php');
include_once('meta-boxes/home_banner.php');
add_action( 'wp_enqueue_scripts', 'indyafoods_theme_enqueue_styles', 11 );
function indyafoods_theme_enqueue_styles() {
    wp_enqueue_style( 'child-style', get_stylesheet_uri() );
	// Add additional styles
    wp_enqueue_style( 'custom-style', get_stylesheet_directory_uri() . '/css/custom-style.css', array('child-style'), '1.0.0', 'all' );
    wp_enqueue_style( 'responsive-style', get_stylesheet_directory_uri() . '/css/responsive.css', array('child-style'), '1.0.0', 'all' );
}
function enqueue_slick_slider_assets() {
    // Slick CSS (loaded in header)
    wp_enqueue_style(
        'slick-css',
        'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css',
        array(),
        '1.8.1',
        'all'
    );

    // Optional Slick theme CSS
    wp_enqueue_style(
        'slick-theme-css',
        'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css',
        array('slick-css'),
        '1.8.1',
        'all'
    );

    // Slick JS (loaded in footer)
    wp_enqueue_script(
        'slick-js',
        'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js',
        array('jquery'), // depends on jQuery
        '1.8.1',
        true // Load in footer
    );
}
add_action('wp_enqueue_scripts', 'enqueue_slick_slider_assets');
function trim_characters_with_read_more($content,$name,$company, $limit = 100) {
	$content=strip_tags($content);
	if (mb_strlen($content) > $limit) {
    $trimmed_content = mb_substr($content, 0, $limit);
	}
	else{
		$trimmed_content=$content;
	}
    if (mb_strlen($content) > $limit) {
        $trimmed_content .= '... <a href="' . get_permalink() . '" class="read-more-testi md-trigger" text="'.$content.'" name="'.$name.'"  company="'.$company.'">Read More</a>';
    }
    return $trimmed_content;
}
function register_blog_post_type_and_taxonomy() {
    // Register Custom Post Type: Case Study
    $post_labels = array(
        'name'               => 'Insights',
        'singular_name'      => 'Insight',
        'menu_name'          => 'Insights',
        'name_admin_bar'     => 'Insights',
        'add_new'            => 'Add New',
        'add_new_item'       => 'Add New Insight',
        'new_item'           => 'New Insight',
        'edit_item'          => 'Edit Insight',
        'view_item'          => 'View Insight',
        'all_items'          => 'All Insight',
        'search_items'       => 'Search Insight',
        'not_found'          => 'No insigh found.',
        'not_found_in_trash' => 'No insight found in Trash.'
    );

    $post_args = array(
        'labels'             => $post_labels,
        'public'             => true,
        'has_archive'        => false,
        'rewrite'            => array('slug' => 'blog'),
        'supports'           => array('title', 'editor', 'thumbnail', 'excerpt', 'custom-fields'),
		'taxonomies' => array('post_tag'), // Add category and tags
        'menu_position'      => 5,
        'menu_icon'          => 'dashicons-analytics', // Case Study icon
        'show_in_rest'       => true, // Enable for Gutenberg
    );

    register_post_type('blog', $post_args);

    // Register Custom Taxonomy: Case Study Categories
    $tax_labels = array(
        'name'              => 'Insight Categories',
        'singular_name'     => 'Insight Category',
        'search_items'      => 'Search Categories',
        'all_items'         => 'All Categories',
        'edit_item'         => 'Edit Category',
        'update_item'       => 'Update Category',
        'add_new_item'      => 'Add New Category',
        'new_item_name'     => 'New Category Name',
        'menu_name'         => 'Categories',
    );

    $tax_args = array(
        'hierarchical'      => true, // Works like post categories
        'labels'            => $tax_labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'blog-category'),
    );

    register_taxonomy('blog_category', 'blog', $tax_args);
}

// Hook to WordPress Init
add_action('init', 'register_blog_post_type_and_taxonomy');
function add_blog_custom_meta_box() {
    add_meta_box(
        'blog_author',
        'Blog Author',
        'blog_author_callback',
        'blog',
        'normal',
        'high'
    );
}
add_action('add_meta_boxes', 'add_blog_custom_meta_box');
function blog_author_callback($post) {
    $author_name = get_post_meta($post->ID, '_blog_author', true);
    ?>
    <label for="blog_author">Author Name:</label>
    <input type="text" id="blog_author" name="blog_author" value="<?php echo esc_attr($author_name); ?>" style="width:100%;" />
    <?php
}
function save_blog_author_meta($post_id) {
    if (isset($_POST['blog_author'])) {
        update_post_meta($post_id, '_blog_author', sanitize_text_field($_POST['blog_author']));
    }
}
add_action('save_post', 'save_blog_author_meta');
add_action('wp_ajax_insights_listing_with_pagination', 'insights_listing_with_pagination');
add_action('wp_ajax_nopriv_insights_listing_with_pagination', 'insights_listing_with_pagination');
function insights_listing_with_pagination() {
    $category = isset($_POST['category']) ? $_POST['category'] : [];
    $paged = (int) $_POST['page'];
	$search_term = isset($_POST['search']) ? sanitize_text_field($_POST['search']) : '';
	$selectedcat = isset($_POST['selectedcat']) ? sanitize_text_field($_POST['selectedcat']) : '';
    $args = array(
        'post_type' => 'blog',
        'posts_per_page' => 6,
        'paged' => $paged,
		'post_status' => 'publish',
		'orderby' => 'date',
        'order' => 'DESC'
    );

    if (!empty($category)) {
        $args['tax_query'] = array(
			array(
                'taxonomy' => 'blog_category', // Change this to your custom taxonomy
                'field' => 'slug',
                'terms' => $category,
            ),
		);
    }
	elseif(!empty($selectedcat)){
		$args['tax_query'] = array(
			array(
                'taxonomy' => 'blog_category', // Change this to your custom taxonomy
                'field' => 'slug',
                'terms' => $selectedcat,
            ),
		);
	}
	else{
		
	}
	if (!empty($search_term)) {
		$args['s'] = $search_term;
	}
    $query = new WP_Query($args);
    $posts = '';
    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            ob_start();
             $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'full'); 
				$thumbnail_id  = get_post_thumbnail_id(get_the_ID());
  				$thumbnail_alt = get_post_meta( $thumbnail_id, '_wp_attachment_image_alt', true );		
				$date = get_the_date();
				$post_date=date('F j, Y', strtotime($date));
				$tags = get_the_terms(get_the_ID(), 'post_tag'); 
				$custom_author_name = get_post_meta(get_the_ID(), '_blog_author', true);
				$category = wp_get_post_terms(get_the_ID(), 'blog_category', array('fields' => 'names'));
				if (!empty($category)) : $i=1; 
                    foreach ($category as $cat) : 
                        $item_category=$cat;
						if($i==1){
							break;
						}
                    endforeach;
                endif; ?>
					<div class="blog-each-holder case-study-each">
					<div class="blogs-info">
							<a href="<?php echo get_the_permalink(); ?>">
							<div class="img-txt1">
								<img decoding="async" src="<?php echo $featured_img_url; ?>" alt="<?php echo $thumbnail_alt; ?>" class="featured-blog-img">
							</div>
							<div class="blog-content">
								<div class="insight-cat">
									<p> <?php echo $item_category; ?> | 5 min read</p>
								</div>
								<div class="img-txt2">
									<p><?php echo mb_strimwidth(get_the_title(), 0, 80, '...'); ?></p>
								</div>
								<div class="tag-holder">
								<?php if ($tags && !is_wp_error($tags)) : ?>
									<?php foreach ($tags as $tag) : ?>
										<span class="pills_button"><?php echo esc_html($tag->name); ?></span>
									<?php endforeach; ?>
							<?php endif; ?>
								</div>
								<div class="author-holder">
									<?php if (!empty($custom_author_name)) {
											echo '<p class="case-study-author">' . esc_html($custom_author_name) . '</p>';
										} else {
											echo '<p class="case-study-author">' . esc_html(get_the_author_meta('display_name')) . '</p>'; // Fallback to default author
										} ?>
								</div>
								<div class="blog-last">
									<p><svg width="18" height="11" viewBox="0 0 18 11" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.00893 2.95947C7.72404 2.95947 6.67871 4.00325 6.67871 5.28614C6.67871 6.56903 7.72404 7.61281 9.00893 7.61281C10.2938 7.61281 11.3392 6.56903 11.3392 5.28614C11.3392 4.00325 10.2938 2.95947 9.00893 2.95947ZM9.00893 7.16836C7.96916 7.16836 7.12316 6.32414 7.12316 5.28614C7.12316 4.24814 7.96916 3.40392 9.00893 3.40392C10.0487 3.40392 10.8945 4.24814 10.8945 5.28614C10.8945 6.32414 10.0487 7.16836 9.00893 7.16836Z" fill="black" stroke="black" stroke-width="0.727273"/>
<path d="M9 0.507324C5.436 0.507324 2.37111 2.46932 1 5.2851C2.37111 8.10088 5.436 10.0629 9 10.0629C12.5638 10.0629 15.6289 8.10088 17 5.2851C15.6289 2.46932 12.5638 0.507324 9 0.507324ZM9 9.61844C5.80022 9.61844 2.88111 7.92466 1.498 5.2851C2.88111 2.64555 5.80022 0.951769 9 0.951769C12.1996 0.951769 15.1189 2.64555 16.5022 5.2851C15.1189 7.92466 12.1996 9.61844 9 9.61844Z" fill="black" stroke="black" stroke-width="0.727273"/>
</svg> 3k Views</p>
								</div>
							</div>
							</a>
						</div>
					</div>
            <?php
            $posts .= ob_get_clean();
        }
    }
	else{ 
		$posts .='<div class="no_result"><p>No matching result</p></div>';
	}

      // Generate pagination
    $pagination = paginate_links(array(
        'base' => add_query_arg('paged', '%#%'),
        'format' => '',
        'current' => max(1, $paged),
        'total' => $query->max_num_pages,
        'type' => 'array',
        'prev_text' => 'Prev',
        'next_text' => 'Next',
    ));

    $pagination_html = '';
    if ($pagination) {
        $pagination_html .= '<ul class="pagination">';
        foreach ($pagination as $page_link) {
            $page_number = null;
            if (preg_match('/page\/([0-9]+)/', $page_link, $matches)) {
                $page_number = $matches[1];
            } elseif (strpos($page_link, 'prev') !== false) {
                $page_number = max(1, $paged - 1);
            } elseif (strpos($page_link, 'next') !== false) {
                $page_number = $paged + 1;
            } elseif (preg_match('/\d+/', strip_tags($page_link), $matches)) {
                $page_number = $matches[0];
            }

            if ($page_number) {
                $pagination_html .= '<li>' . str_replace('<a', '<a data-page="' . $page_number . '"', $page_link) . '</li>';
            } else {
                $pagination_html .= '<li>' . $page_link . '</li>';
            }
        }
        $pagination_html .= '</ul>';
    }


    wp_reset_postdata();

    $response = array(
        'posts' => $posts,
        'pagination' => $pagination_html,
    );

    wp_send_json($response);
}
function add_homepage_preloader_html() {
    if (is_front_page()) {
        ?>
        <div id="preloader">
            <img src="<?php echo site_url(); ?>/wp-content/uploads/2025/03/footer-logo.png" alt="Logo" class="preloader-logo" />
        </div>
        <?php
    }
}
add_action('wp_body_open', 'add_homepage_preloader_html');
function enqueue_homepage_preloader_script() {
    if (is_front_page()) {
        // Enqueue jQuery if needed
        wp_enqueue_script('jquery');

        // Register a dummy script handle to attach our inline script
        wp_register_script('homepage-preloader', '', [], null, true);
        wp_enqueue_script('homepage-preloader');

        // Your preloader script
        $preloader_js = <<<JS
document.addEventListener("DOMContentLoaded", function () {
    const isHome = document.body.classList.contains('home');
    const hasLoaded = sessionStorage.getItem('homepagePreloaded');

    if (isHome && !hasLoaded) {
        sessionStorage.setItem('homepagePreloaded', 'true');
        window.addEventListener("load", function () {
            const preloader = document.getElementById("preloader");
            if (preloader) {
                preloader.style.opacity = "0";
                setTimeout(() => preloader.remove(), 600);
            }
        });
    } else {
        const preloader = document.getElementById("preloader");
        if (preloader) preloader.remove();
    }
});
JS;

        wp_add_inline_script('homepage-preloader', $preloader_js);
    }
}
add_action('wp_enqueue_scripts', 'enqueue_homepage_preloader_script');
function create_job_openings_post_type() {
    // Register Job Openings Post Type
    $args = array(
        'labels' => array(
            'name' => 'Job Openings',
            'singular_name' => 'Job Opening',
            'menu_name' => 'Job Openings',
            'all_items' => 'All Jobs',
            'add_new' => 'Add New Job',
            'add_new_item' => 'Add New Job',
            'edit_item' => 'Edit Job',
            'new_item' => 'New Job',
            'view_item' => 'View Job',
            'search_items' => 'Search Jobs',
            'not_found' => 'No Jobs found',
            'not_found_in_trash' => 'No Jobs found in trash'
        ),
        'public' => true,
        'has_archive' => false,
        'rewrite' => array('slug' => 'jobs'),
        'supports' => array('title', 'editor','thumbnail'),
        'menu_icon' => 'dashicons-businessman', // Job icon in admin menu
        'show_in_rest' => true, // Enables Gutenberg editor
    );
    register_post_type('job_openings', $args);

    // Register Job Type Taxonomy
    $tax_args = array(
        'labels' => array(
            'name' => 'Job Types',
            'singular_name' => 'Job Type',
            'menu_name' => 'Job Types',
            'all_items' => 'All Job Types',
            'edit_item' => 'Edit Job Type',
            'view_item' => 'View Job Type',
            'update_item' => 'Update Job Type',
            'add_new_item' => 'Add New Job Type',
            'new_item_name' => 'New Job Type Name',
            'search_items' => 'Search Job Types'
        ),
        'hierarchical' => true, // Works like categories
        'public' => true,
        'show_admin_column' => true,
        'rewrite' => array('slug' => 'job-type'),
        'show_in_rest' => true, // Enable Gutenberg support
    );
    register_taxonomy('job_type', 'job_openings', $tax_args);
}

// Hook the function into WordPress
add_action('init', 'create_job_openings_post_type');
add_action('wp_ajax_fetch_job_openings', 'fetch_job_openings');
add_action('wp_ajax_nopriv_fetch_job_openings', 'fetch_job_openings');
function fetch_job_openings() {
    $paged = isset($_POST['paged']) ? intval($_POST['paged']) : 1;
    $search_query = isset($_POST['search']) ? sanitize_text_field($_POST['search']) : '';
    $selected_types = isset($_POST['job_types']) ? $_POST['job_types'] : [];

    $args = array(
        'post_type'      => 'job_openings',
        'posts_per_page' => 3, // Show 3 jobs per page
        'paged'          => $paged,
        's'              => $search_query,
    );

    if (!empty($selected_types)) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'job_type',
                'field'    => 'slug',
                'terms'    => $selected_types,
            ),
        );
    }
    $query = new WP_Query($args);
    $posts = '';
    if ($query->have_posts()) {
		 ob_start();
        while ($query->have_posts()) {
            $query->the_post();
             $job_types = wp_get_post_terms(get_the_ID(), 'job_type', array('fields' => 'names'));
			$featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'full'); 
				$thumbnail_id  = get_post_thumbnail_id(get_the_ID());
  				$thumbnail_alt = get_post_meta( $thumbnail_id, '_wp_attachment_image_alt', true );
				$linkedin_url = get_post_meta(get_the_ID(), '_job_linkedin_url', true);
            ?>
				<li>
                <div class="content_full_width">
					<div class="left_image">
						<img src="<?php echo $featured_img_url; ?>" alt="<?php echo $thumbnail_alt; ?>"/>
					</div>
                    <div class="left_content">
						<h3><a href="#" style="font-size:30px" target="_blank"><?php the_title(); ?></a></h3>
                        <?php the_excerpt(); ?>
						<?php if (!empty($job_types)) : 
							foreach ($job_types as $type) : ?>
								<span class="pills_button"><?php echo esc_html($type); ?></span>
							<?php endforeach;
						endif; ?>
                    </div>
					<?php if ($linkedin_url) { ?>
                    <div class="apply-holder">
						<a href="<?php echo esc_url($linkedin_url); ?>" target="_blank">Apply<img src="<?php echo site_url(); ?>/wp-content/uploads/2025/04/Vector-1.png" /></a>
					</div>
					<?php } ?>
                </div>
            </li>

            <?php
        }
		$posts .= ob_get_clean();
    }
	else{ 
		$posts .='<div class="no_result"><p>No matching result</p></div>';
	}

      // Generate pagination
    $pagination = paginate_links(array(
        'base' => add_query_arg('paged', '%#%'),
        'format' => '',
        'current' => max(1, $paged),
        'total' => $query->max_num_pages,
        'type' => 'array',
        'prev_text' => '<svg width="29" height="29" viewBox="0 0 29 29" fill="none" xmlns="http://www.w3.org/2000/svg"><g><path d="M27.0082 20.1247C27.1655 19.7846 27.0163 19.3808 26.6773 19.2247C26.3372 19.0673 25.9335 19.2166 25.7773 19.5567C24.7419 21.7801 23.09 23.6565 21.039 24.9649C19.055 26.2304 16.6963 26.9639 14.1616 26.9639C10.6253 26.9639 7.42546 25.5306 5.10842 23.2147C2.79247 20.8987 1.35922 17.6978 1.35922 14.1615C1.35922 10.6252 2.7925 7.42537 5.10842 5.10833C7.42552 2.79238 10.6253 1.35913 14.1616 1.35913C16.6962 1.35913 19.0548 2.09256 21.039 3.35811C23.09 4.66648 24.7431 6.54286 25.7773 8.76632C25.9335 9.10641 26.3372 9.25448 26.6773 9.09832C27.0174 8.94215 27.1655 8.53843 27.0082 8.19831C25.8652 5.74007 24.0352 3.66462 21.7667 2.21647C19.5664 0.813245 16.9579 0 14.1617 0C10.2505 0 6.71066 1.58485 4.14841 4.1484C1.58491 6.7119 0 10.2517 0 14.1629C0 18.074 1.58485 21.6139 4.14841 24.1773C6.71196 26.7407 10.2517 28.3257 14.1617 28.3257C16.9565 28.3257 19.5675 27.5125 21.7667 26.1092C24.0364 24.6609 25.8653 22.5857 27.0082 20.1274V20.1247ZM11.6918 14.8403H28.3198C28.6946 14.8403 29 14.536 29 14.16C29 13.7852 28.6958 13.4798 28.3198 13.4798H11.6918L16.7725 8.98671C17.0524 8.73915 17.0779 8.31114 16.8315 8.03116C16.5839 7.75121 16.1559 7.72459 15.8759 7.97217L9.45314 13.6522C9.17319 13.8998 9.14776 14.3278 9.39414 14.6078C9.41497 14.6309 9.43579 14.6517 9.45777 14.6714L15.8746 20.3455C16.1546 20.5931 16.5826 20.5677 16.8302 20.2865C17.0777 20.0066 17.0523 19.5786 16.7712 19.331L11.6905 14.8379L11.6918 14.8403Z" fill="#1A2148"/></g></svg>
',
        'next_text' => '<svg width="29" height="29" viewBox="0 0 29 29" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M1.99184 20.1247C1.83452 19.7846 1.98375 19.3808 2.3227 19.2247C2.66279 19.0673 3.06653 19.2166 3.22271 19.5567C4.25807 21.7801 5.90999 23.6565 7.96104 24.9649C9.94497 26.2304 12.3037 26.9639 14.8384 26.9639C18.3747 26.9639 21.5745 25.5306 23.8916 23.2147C26.2075 20.8987 27.6408 17.6978 27.6408 14.1615C27.6408 10.6252 26.2075 7.42537 23.8916 5.10833C21.5745 2.79238 18.3747 1.35913 14.8384 1.35913C12.3038 1.35913 9.94521 2.09256 7.96104 3.35811C5.90999 4.66648 4.25685 6.54286 3.22271 8.76632C3.06654 9.10641 2.66282 9.25448 2.3227 9.09832C1.9826 8.94215 1.83453 8.53843 1.99184 8.19831C3.13479 5.74007 4.96485 3.66462 7.23332 2.21647C9.43359 0.813245 12.0421 0 14.8383 0C18.7495 0 22.2893 1.58485 24.8516 4.1484C27.4151 6.7119 29 10.2517 29 14.1629C29 18.074 27.4151 21.6139 24.8516 24.1773C22.288 26.7407 18.7483 28.3257 14.8383 28.3257C12.0435 28.3257 9.43249 27.5125 7.23332 26.1092C4.96363 24.6609 3.13467 22.5857 1.99184 20.1274V20.1247ZM17.3082 14.8403H0.680216C0.305415 14.8403 0 14.536 0 14.16C0 13.7852 0.30423 13.4798 0.680216 13.4798H17.3082L12.2275 8.98671C11.9476 8.73915 11.9221 8.31114 12.1685 8.03116C12.4161 7.75121 12.8441 7.72459 13.1241 7.97217L19.5469 13.6522C19.8268 13.8998 19.8522 14.3278 19.6059 14.6078C19.585 14.6309 19.5642 14.6517 19.5422 14.6714L13.1254 20.3455C12.8454 20.5931 12.4174 20.5677 12.1698 20.2865C11.9223 20.0066 11.9477 19.5786 12.2288 19.331L17.3095 14.8379L17.3082 14.8403Z" fill="#1A2148"/>
</svg>',
    ));

    $pagination_html = '';
    if ($pagination) {
        $pagination_html .= '<ul class="pagination">';
        foreach ($pagination as $page_link) {
            $page_number = null;
            if (preg_match('/page\/([0-9]+)/', $page_link, $matches)) {
                $page_number = $matches[1];
            } elseif (strpos($page_link, 'prev') !== false) {
                $page_number = max(1, $paged - 1);
            } elseif (strpos($page_link, 'next') !== false) {
                $page_number = $paged + 1;
            } elseif (preg_match('/\d+/', strip_tags($page_link), $matches)) {
                $page_number = $matches[0];
            }

            if ($page_number) {
                $pagination_html .= '<li>' . str_replace('<a', '<a data-page="' . $page_number . '"', $page_link) . '</li>';
            } else {
                $pagination_html .= '<li>' . $page_link . '</li>';
            }
        }
        $pagination_html .= '</ul>';
    }


    wp_reset_postdata();

    $response = array(
        'posts' => $posts,
        'pagination' => $pagination_html,
    );


    wp_send_json($response);
}
function register_testimonial_post_type() {
    $labels = array(
        'name'               => 'Testimonials',
        'singular_name'      => 'Testimonial',
        'menu_name'          => 'Testimonials',
        'name_admin_bar'     => 'Testimonial',
        'add_new'            => 'Add New',
        'add_new_item'       => 'Add New Testimonial',
        'new_item'           => 'New Testimonial',
        'edit_item'          => 'Edit Testimonial',
        'view_item'          => 'View Testimonial',
        'all_items'          => 'All Testimonials',
        'search_items'       => 'Search Testimonials',
        'parent_item_colon'  => 'Parent Testimonials:',
        'not_found'          => 'No testimonials found.',
        'not_found_in_trash' => 'No testimonials found in Trash.'
    );

    $args = array(
        'labels'             => $labels,
        'description'        => 'Customer testimonials',
        'public'             => true,
        'publicly_queryable' => true,
        'show_in_rest'       => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array('slug' => 'testimonials'),
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => 20,
        'menu_icon'          => 'dashicons-testimonial',
        'supports'           => array('title', 'editor', 'custom-fields')
    );

    register_post_type('testimonial', $args);
}
add_action('init', 'register_testimonial_post_type');
add_action('add_meta_boxes', 'testimonial_add_company_meta_box');
function testimonial_add_company_meta_box() {
    add_meta_box(
        'testimonial_company',
        'Company',
        'testimonial_company_meta_box_callback',
        'testimonial', // post type
        'side',
        'default'
    );
}
function testimonial_company_meta_box_callback($post) {
    wp_nonce_field('testimonial_save_company', 'testimonial_company_nonce');

    $company = get_post_meta($post->ID, '_testimonial_company', true);

    echo '<label for="testimonial_company">Company Name:</label>';
    echo '<input type="text" id="testimonial_company" name="testimonial_company" value="' . esc_attr($company) . '" style="width:100%;" />';
}
add_action('save_post', 'testimonial_save_company_meta_box');
function testimonial_save_company_meta_box($post_id) {
    if (!isset($_POST['testimonial_company_nonce']) || !wp_verify_nonce($_POST['testimonial_company_nonce'], 'testimonial_save_company')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

    if (isset($_POST['testimonial_company'])) {
        update_post_meta($post_id, '_testimonial_company', sanitize_text_field($_POST['testimonial_company']));
    }
}
add_action('add_meta_boxes', 'job_openings_add_linkedin_meta_box');
function job_openings_add_linkedin_meta_box() {
    add_meta_box(
        'job_linkedin_url',
        'Job Link in LinkedIn',
        'job_linkedin_meta_box_callback',
        'job_openings', // custom post type
        'normal',
        'default'
    );
}
function job_linkedin_meta_box_callback($post) {
    wp_nonce_field('job_linkedin_save_meta_box', 'job_linkedin_nonce');

    $linkedin_url = get_post_meta($post->ID, '_job_linkedin_url', true);

    echo '<label for="job_linkedin_url">LinkedIn Job URL:</label>';
    echo '<input type="url" id="job_linkedin_url" name="job_linkedin_url" value="' . esc_attr($linkedin_url) . '" style="width:100%;" placeholder="https://www.linkedin.com/jobs/view/...">';
}
add_action('save_post', 'job_linkedin_save_meta_box');
function job_linkedin_save_meta_box($post_id) {
    if (!isset($_POST['job_linkedin_nonce']) || !wp_verify_nonce($_POST['job_linkedin_nonce'], 'job_linkedin_save_meta_box')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

    if (isset($_POST['job_linkedin_url'])) {
        update_post_meta($post_id, '_job_linkedin_url', esc_url_raw($_POST['job_linkedin_url']));
    }
}